# Generated by Django 5.0.7 on 2025-01-21 10:04

import cmsapp.models
import django.db.models.deletion
import django.utils.timezone
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('auth', '0012_alter_user_first_name_max_length'),
    ]

    operations = [
        migrations.CreateModel(
            name='LandDistanceFromLandmark',
            fields=[
                ('id', models.BigAutoField(primary_key=True, serialize=False)),
                ('landmark_name', models.CharField(max_length=100)),
                ('distance_in_km', models.IntegerField()),
                ('created_at', models.DateTimeField(default=django.utils.timezone.now)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('status', models.SmallIntegerField(default=1)),
            ],
            options={
                'db_table': 'tbl_land_distance',
            },
        ),
        migrations.CreateModel(
            name='PlotDetailsModel',
            fields=[
                ('id', models.BigAutoField(primary_key=True, serialize=False)),
                ('khatiyan_document', models.FileField(upload_to=None)),
                ('khatiyan_receipt', models.FileField(upload_to=None)),
                ('village_map', models.TextField()),
                ('trace_map', models.TextField()),
                ('plot_address', models.TextField()),
                ('plot_image', models.FileField(max_length=200, upload_to=None)),
                ('plot_video', models.FileField(max_length=200, upload_to=None)),
                ('mouja_name', models.CharField(max_length=100)),
                ('created_at', models.DateTimeField(default=django.utils.timezone.now)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('status', models.SmallIntegerField(default=1)),
            ],
            options={
                'db_table': 'tbl_plot_details',
            },
        ),
        migrations.CreateModel(
            name='StateModel',
            fields=[
                ('id', models.BigAutoField(primary_key=True, serialize=False)),
                ('name', models.CharField(max_length=100)),
                ('created_at', models.DateTimeField(default=django.utils.timezone.now)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('status', models.IntegerField(default=1)),
            ],
            options={
                'db_table': 'tbl_state',
            },
        ),
        migrations.CreateModel(
            name='CustomUser',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('password', models.CharField(max_length=128, verbose_name='password')),
                ('is_superuser', models.BooleanField(default=False, help_text='Designates that this user has all permissions without explicitly assigning them.', verbose_name='superuser status')),
                ('email', models.EmailField(blank=True, max_length=254, null=True, unique=True)),
                ('name', models.CharField(max_length=255)),
                ('is_active', models.BooleanField(default=True)),
                ('is_staff', models.BooleanField(default=False)),
                ('last_login', models.DateTimeField(blank=True, null=True)),
                ('address', models.TextField()),
                ('area', models.CharField(blank=True, max_length=150, null=True)),
                ('created_at', models.DateTimeField(default=django.utils.timezone.now)),
                ('memberID', models.CharField(blank=True, max_length=15, null=True, unique=True)),
                ('phone_number', models.CharField(blank=True, max_length=15, null=True, unique=True)),
                ('groups', models.ManyToManyField(blank=True, help_text='The groups this user belongs to. A user will get all permissions granted to each of their groups.', related_name='user_set', related_query_name='user', to='auth.group', verbose_name='groups')),
                ('user_permissions', models.ManyToManyField(blank=True, help_text='Specific permissions for this user.', related_name='user_set', related_query_name='user', to='auth.permission', verbose_name='user permissions')),
            ],
            options={
                'db_table': 'tbl_user',
            },
        ),
        migrations.CreateModel(
            name='MemberModel',
            fields=[
                ('id', models.BigAutoField(primary_key=True, serialize=False)),
                ('sponserID', models.CharField(max_length=50)),
                ('sponsorName', models.CharField(max_length=100)),
                ('name', models.CharField(blank=True, max_length=100, null=True)),
                ('adhar_no', models.CharField(max_length=12)),
                ('pan_no', models.CharField(max_length=10)),
                ('address', models.TextField(blank=True, null=True)),
                ('state', models.CharField(max_length=100)),
                ('city', models.CharField(max_length=100)),
                ('pincode', models.CharField(max_length=6)),
                ('created_at', models.DateTimeField(default=django.utils.timezone.now)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('status', models.IntegerField(default=1)),
                ('rank', models.CharField(max_length=10)),
                ('registration_fee', models.DecimalField(decimal_places=2, max_digits=5)),
                ('sponser_member', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='cmsapp.membermodel')),
                ('user_detail', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'db_table': 'tbl_member',
            },
        ),
        migrations.CreateModel(
            name='PurchaserDetailsModel',
            fields=[
                ('id', models.BigAutoField(primary_key=True, serialize=False)),
                ('purchaser_name', models.CharField(max_length=100)),
                ('phone_no', models.CharField(max_length=15)),
                ('address', models.TextField()),
                ('address_document', models.FileField(upload_to=cmsapp.models.address_document_name_change)),
                ('purchaser_photo', models.ImageField(upload_to=cmsapp.models.purchaser_photo_name_change)),
                ('aadhar_card_no', models.CharField(max_length=12)),
                ('pan_no', models.CharField(max_length=10)),
                ('amount_paid', models.DecimalField(decimal_places=2, max_digits=10)),
                ('created_at', models.DateTimeField(default=django.utils.timezone.now)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('status', models.SmallIntegerField(default=1)),
                ('member_id', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='cmsapp.membermodel')),
                ('plot_dtl', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='cmsapp.plotdetailsmodel')),
            ],
            options={
                'db_table': 'tbl_purchaser',
            },
        ),
        migrations.CreateModel(
            name='PlotBookingDetailsModel',
            fields=[
                ('id', models.BigAutoField(primary_key=True, serialize=False)),
                ('no_of_decimil', models.IntegerField()),
                ('price', models.DecimalField(decimal_places=2, max_digits=10)),
                ('total_amount', models.DecimalField(decimal_places=2, max_digits=10)),
                ('member', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='cmsapp.membermodel', verbose_name='')),
                ('plot_dtl', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='cmsapp.plotdetailsmodel', verbose_name='')),
                ('purchaser_detail', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='cmsapp.purchaserdetailsmodel', verbose_name='')),
            ],
            options={
                'db_table': 'tbl_plot_sell_details',
            },
        ),
        migrations.CreateModel(
            name='CityModel',
            fields=[
                ('id', models.BigAutoField(primary_key=True, serialize=False)),
                ('name', models.CharField(max_length=100)),
                ('created_at', models.DateTimeField(default=django.utils.timezone.now)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('status', models.IntegerField(default=1)),
                ('state', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='cmsapp.statemodel')),
            ],
            options={
                'db_table': 'tbl_city',
            },
        ),
    ]
